/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes.client.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.nick.chimes.client.ChimesSettings;
import com.nick.chimes.common.blockentity.MetalChimesTile;
import com.nick.chimes.util.lists.ChimesBlocks;
import com.nick.chimes.util.lists.ChimesStates;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class IronChimesRenderer
implements BlockEntityRenderer<MetalChimesTile> {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty SILENCED = ChimesStates.SILENCED;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static ModelLayerLocation IRON_CHIMES_LAYER = new ModelLayerLocation(new ResourceLocation("chimes", "block/metal_chimes"), "Chimes");
    public static final Material IRON = new Material(TextureAtlas.f_118259_, new ResourceLocation("chimes", "block/metal_chimes"));
    private final ModelPart MetalTopper;
    private final ModelPart Topper;
    private final ModelPart TopperBoneA;
    private final ModelPart BigStrA;
    private final ModelPart BigA;
    private final ModelPart SmaStrA;
    private final ModelPart SmaA;
    private final ModelPart MedStrA;
    private final ModelPart MedA;
    private final ModelPart LarStrA;
    private final ModelPart LarA;
    private final ModelPart MetalLower;
    private final ModelPart TopperBoneB;
    private final ModelPart LarStrB;
    private final ModelPart LarB;
    private final ModelPart BigStrB;
    private final ModelPart BigB;
    private final ModelPart MedStrB;
    private final ModelPart MedB;
    private final ModelPart SmaStrB;
    private final ModelPart SmaB;
    private final ModelPart TopperBone;

    public IronChimesRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart root = context.m_173582_(IRON_CHIMES_LAYER);
        BlockEntityRenderDispatcher renderer = context.m_173581_();
        this.MetalTopper = root.m_171324_("MetalTopper");
        this.Topper = this.MetalTopper.m_171324_("Topper");
        this.TopperBoneA = this.Topper.m_171324_("TopperBoneA");
        this.BigStrA = this.TopperBoneA.m_171324_("BigStrA");
        this.BigA = this.BigStrA.m_171324_("BigA");
        this.SmaStrA = this.TopperBoneA.m_171324_("SmaStrA");
        this.SmaA = this.SmaStrA.m_171324_("SmaA");
        this.MedStrA = this.TopperBoneA.m_171324_("MedStrA");
        this.MedA = this.MedStrA.m_171324_("MedA");
        this.LarStrA = this.TopperBoneA.m_171324_("LarStrA");
        this.LarA = this.LarStrA.m_171324_("LarA");
        this.MetalLower = root.m_171324_("MetalLower");
        this.TopperBoneB = this.MetalLower.m_171324_("TopperBoneB");
        this.LarStrB = this.TopperBoneB.m_171324_("LarStrB");
        this.LarB = this.LarStrB.m_171324_("LarB");
        this.BigStrB = this.TopperBoneB.m_171324_("BigStrB");
        this.BigB = this.BigStrB.m_171324_("BigB");
        this.MedStrB = this.TopperBoneB.m_171324_("MedStrB");
        this.MedB = this.MedStrB.m_171324_("MedB");
        this.SmaStrB = this.TopperBoneB.m_171324_("SmaStrB");
        this.SmaB = this.SmaStrB.m_171324_("SmaB");
        this.TopperBone = root.m_171324_("TopperBone");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition MetalTopper = partdefinition.m_171599_("MetalTopper", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition Topper = MetalTopper.m_171599_("Topper", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition TopperBoneA = Topper.m_171599_("TopperBoneA", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition BigStrA = TopperBoneA.m_171599_("BigStrA", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-3.0f));
        PartDefinition BigA = BigStrA.m_171599_("BigA", CubeListBuilder.m_171558_().m_171514_(8, 12).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition SmaStrA = TopperBoneA.m_171599_("SmaStrA", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.0f, (float)2.0f, (float)0.0f));
        PartDefinition SmaA = SmaStrA.m_171599_("SmaA", CubeListBuilder.m_171558_().m_171514_(24, 12).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition MedStrA = TopperBoneA.m_171599_("MedStrA", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)3.0f));
        PartDefinition MedA = MedStrA.m_171599_("MedA", CubeListBuilder.m_171558_().m_171514_(16, 12).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition LarStrA = TopperBoneA.m_171599_("LarStrA", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.0f, (float)2.0f, (float)0.0f));
        PartDefinition LarA = LarStrA.m_171599_("LarA", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition MetalLower = partdefinition.m_171599_("MetalLower", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition TopperBoneB = MetalLower.m_171599_("TopperBoneB", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition LarStrB = TopperBoneB.m_171599_("LarStrB", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.0f, (float)2.0f, (float)0.0f));
        PartDefinition LarB = LarStrB.m_171599_("LarB", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171488_(-1.0f, 9.0f, -1.0f, 2.0f, 13.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition BigStrB = TopperBoneB.m_171599_("BigStrB", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-3.0f));
        PartDefinition BigB = BigStrB.m_171599_("BigB", CubeListBuilder.m_171558_().m_171514_(8, 23).m_171488_(-1.0f, 9.0f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition MedStrB = TopperBoneB.m_171599_("MedStrB", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)3.0f));
        PartDefinition MedB = MedStrB.m_171599_("MedB", CubeListBuilder.m_171558_().m_171514_(16, 23).m_171488_(-1.0f, 9.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition SmaStrB = TopperBoneB.m_171599_("SmaStrB", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.0f, (float)2.0f, (float)0.0f));
        PartDefinition SmaB = SmaStrB.m_171599_("SmaB", CubeListBuilder.m_171558_().m_171514_(24, 23).m_171488_(-1.0f, 9.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition TopperBone = partdefinition.m_171599_("TopperBone", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition Chain1_r1 = TopperBone.m_171599_("Chain1_r1", CubeListBuilder.m_171558_().m_171514_(32, 3).m_171488_(-1.5f, 0.0f, 0.0f, 3.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition Chain_r1 = TopperBone.m_171599_("Chain_r1", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-1.5f, -4.0f, 0.0f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition TopperBoneBase = TopperBone.m_171599_("TopperBoneBase", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, 0.0f, -5.0f, 10.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition TopperStringLar = TopperBoneBase.m_171599_("TopperStringLar", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.0f, (float)2.0f, (float)0.0f));
        PartDefinition LarString_r1 = TopperStringLar.m_171599_("LarString_r1", CubeListBuilder.m_171558_().m_171514_(38, 0).m_171488_(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition TopperStringBig = TopperBoneBase.m_171599_("TopperStringBig", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-3.0f));
        PartDefinition BigString_r1 = TopperStringBig.m_171599_("BigString_r1", CubeListBuilder.m_171558_().m_171514_(38, 0).m_171488_(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition TopperBoneSma = TopperBoneBase.m_171599_("TopperBoneSma", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.0f, (float)2.0f, (float)0.0f));
        PartDefinition SmaString_r1 = TopperBoneSma.m_171599_("SmaString_r1", CubeListBuilder.m_171558_().m_171514_(38, 0).m_171488_(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition TopperBoneMed = TopperBoneBase.m_171599_("TopperBoneMed", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)3.0f));
        PartDefinition MedString_r1 = TopperBoneMed.m_171599_("MedString_r1", CubeListBuilder.m_171558_().m_171514_(38, 0).m_171488_(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(MetalChimesTile tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        VertexConsumer ivertexbuilder = IRON.m_119194_(bufferIn, RenderType::m_110452_);
        BlockState blockstate = tileEntityIn.m_58900_();
        Direction flag3 = (Direction)blockstate.m_61143_((Property)FACING);
        BlockPos pos = tileEntityIn.m_58899_();
        ChimesSettings animateoptioncheck = ChimesSettings.getInstance();
        float f3 = 1.0f;
        if ((float)tileEntityIn.velocityTicks <= 0.0f || (float)tileEntityIn.velocityTicks >= 2.0f) {
            f3 = (float)tileEntityIn.velocityTicks * 0.25f;
        }
        if ((float)tileEntityIn.velocityTicks >= 0.0f && (float)tileEntityIn.velocityTicks <= 2.0f) {
            if (blockstate.m_61143_((Property)SILENCED) == Boolean.FALSE) {
                f3 = ((float)tileEntityIn.velocityTicks + partialTicks) * 0.25f;
            }
            if (blockstate.m_61143_((Property)SILENCED) == Boolean.TRUE) {
                f3 = ((float)tileEntityIn.velocityTicks - partialTicks) * 0.25f;
            }
        }
        float s1 = 1.0f;
        if (tileEntityIn.silenceTicks <= 0 || tileEntityIn.silenceTicks >= 200) {
            s1 = 0.0f;
        }
        if (tileEntityIn.silenceTicks >= 0 && tileEntityIn.silenceTicks <= 200 && blockstate.m_61143_((Property)SILENCED) == Boolean.TRUE) {
            s1 = (float)tileEntityIn.silenceTicks + partialTicks;
        }
        float s01 = Mth.m_14031_((float)(s1 * 0.8f / (float)Math.PI)) / (1.0f + s1 / 0.25f);
        float s02 = Mth.m_14031_((float)(s1 * 0.95f / (float)Math.PI)) / (1.0f + s1 / 0.25f);
        float s03 = Mth.m_14031_((float)(s1 * 1.15f / (float)Math.PI)) / (1.0f + s1 / 0.25f);
        float s04 = Mth.m_14031_((float)(s1 * 1.2f / (float)Math.PI)) / (1.0f + s1 / 0.25f);
        float f = (float)tileEntityIn.interactTicks + partialTicks;
        float f1 = (float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTicks + (float)(pos.m_123341_() * 7) + (float)(pos.m_123343_() * 13);
        float f4 = Mth.m_14031_((float)(f / (float)Math.PI)) / (9.0f + f / 2.9f);
        float f5 = Mth.m_14031_((float)(f * 1.5f / (float)Math.PI)) / (5.0f + f / 2.9f);
        float f04 = Mth.m_14031_((float)(f * 1.15f / (float)Math.PI)) / (9.0f + f / 1.9f);
        float f05 = Mth.m_14031_((float)(f * 1.25f / (float)Math.PI)) / (10.0f + f / 5.9f);
        float f9 = (float)(Math.sin((double)f1 * 0.1) * (double)0.045f) * f3;
        float f01 = (float)(Math.sin((double)f1 * 0.082) * (double)0.058f) * f3;
        float f02 = (float)(Math.sin((double)f1 * 0.071) * (double)0.052f) * f3;
        float f03 = (float)(Math.sin((double)f1 * 0.15) * (double)0.035f) * f3;
        float f0a = (float)(Math.sin((double)f1 * 0.055) * 0.5);
        float f15 = (float)Math.sin((double)f1 * 0.01) * 0.2f;
        float f10 = (float)Math.sin((double)f1 * 0.011) * 0.18f;
        float f11 = (float)Math.sin((double)f1 * 0.14) * 0.009f * f3;
        float f12 = (float)Math.sin((double)f1 * 0.14) * 0.014f * f3;
        float f13 = (float)Math.sin((double)f1 * 0.19) * 0.02f * f3;
        float f14 = (float)Math.sin((double)f1 * 0.25) * 0.025f * f3;
        this.MetalTopper.f_104203_ = (float)Math.PI;
        this.MetalLower.f_104203_ = (float)Math.PI;
        this.TopperBone.f_104203_ = (float)Math.PI;
        this.MetalTopper.m_104227_(8.0f, 16.0f, 8.0f);
        this.MetalLower.m_104227_(8.0f, 32.0f, 8.0f);
        this.TopperBone.m_104227_(8.0f, 16.0f, 8.0f);
        if (flag3 == Direction.NORTH) {
            this.TopperBoneB.f_104204_ = 0.0f;
            this.TopperBoneA.f_104204_ = 0.0f;
        }
        if (flag3 == Direction.EAST) {
            this.TopperBoneB.f_104204_ = 7.853982f;
            this.TopperBoneA.f_104204_ = 7.853982f;
        }
        if (flag3 == Direction.SOUTH) {
            this.TopperBoneB.f_104204_ = (float)Math.PI;
            this.TopperBoneA.f_104204_ = (float)Math.PI;
        }
        if (flag3 == Direction.WEST) {
            this.TopperBoneB.f_104204_ = 4.712389f;
            this.TopperBoneA.f_104204_ = 4.712389f;
        }
        float LarX = f9;
        float LarY = f15 * 0.9f;
        float LarZ = f11;
        float BigX = f01;
        float BigY = f10 * 1.15f;
        float BigZ = f12;
        float MedX = f02;
        float MedY = f15 * 1.751f;
        float MedZ = f13;
        float SmaX = f03;
        float SmaY = -f10 * 1.25f;
        float SmaZ = f14;
        if (flag3 == Direction.EAST || flag3 == Direction.WEST) {
            LarX = f11;
            LarZ = f9;
            BigX = f12;
            BigZ = f01;
            MedX = f13;
            MedZ = f02;
            SmaX = f14;
            SmaZ = f03;
        }
        if (tileEntityIn.isSwinging && blockstate.m_61143_((Property)SILENCED) == Boolean.FALSE) {
            SmaZ = f5 / 1.5f;
            LarZ = -f4 / 1.5f;
            MedX = -f05 / 1.5f;
            BigX = f04 / 1.5f;
        }
        this.LarA.f_104203_ = this.LarB.f_104203_ = LarX;
        this.LarA.f_104204_ = this.LarB.f_104204_ = LarY;
        this.LarA.f_104205_ = this.LarB.f_104205_ = LarZ;
        this.BigA.f_104203_ = this.BigB.f_104203_ = BigX;
        this.BigA.f_104204_ = this.BigB.f_104204_ = BigY;
        this.BigA.f_104205_ = this.BigB.f_104205_ = BigZ;
        this.MedA.f_104203_ = this.MedB.f_104203_ = MedX;
        this.MedA.f_104204_ = this.MedB.f_104204_ = MedY;
        this.MedA.f_104205_ = this.MedB.f_104205_ = MedZ;
        this.SmaA.f_104203_ = this.SmaB.f_104203_ = SmaX;
        this.SmaA.f_104204_ = this.SmaB.f_104204_ = SmaY;
        this.SmaA.f_104205_ = this.SmaB.f_104205_ = SmaZ;
        this.LarB.f_104201_ = 1.0f;
        this.LarA.f_104201_ = 1.0f;
        this.BigB.f_104201_ = 2.0f;
        this.BigA.f_104201_ = 2.0f;
        this.MedB.f_104201_ = 2.0f;
        this.MedA.f_104201_ = 2.0f;
        this.SmaB.f_104201_ = 1.0f;
        this.SmaA.f_104201_ = 1.0f;
        if (blockstate.m_60713_((Block)ChimesBlocks.METALCHIMES)) {
            if (blockstate.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
                this.MetalTopper.m_104301_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn);
                this.TopperBone.m_104301_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            } else {
                this.MetalLower.m_104301_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            }
        }
    }

    public int m_142163_() {
        return 100;
    }
}

